﻿console.log("main.js start");

const {Cc,Cu,Ci} = require("chrome");
Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/AddonManager.jsm");


var prompts = Cc["@mozilla.org/embedcomp/prompt-service;1"].getService(Ci.nsIPromptService);
var tokenReq = require("./token.js");
var token;
var pageMod = require("sdk/page-mod");
var data = require("sdk/self").data;
/*var KBCeTokenFireFoxAddonVersion = AddonManager.getAddonByID("jid1-NCulrYuNIDAzFg@jetpack.xpi", function(addon) {
    return addon.version;
});

console.log("KBCeTokenFireFoxAddonVersion " + KBCeTokenFireFoxAddonVersion);
*/

pageMod.PageMod({
    include: /.*\?electratokenrenew.*/,
    contentScriptWhen: 'end',
//    contentScript: 'document.body.innerHTML = ' +
//    ' "<b>Page matches ruleset</b>";',
    contentScriptFile:
    	[data.url("jquery-1.10.1.min.js"), data.url("jsrsasign-4.6.0-all-min.js"), data.url("asn1pkcs10.js"), data.url("renewal.js")],
    onAttach: function onAttach(worker) {
    	startRenewal(worker);
    }
});

// inject addon version number into the web page DOM
// (used by addon update checker javascript on the web page)
pageMod.PageMod({
    include: /.*\electratokenrenew.*/,
    contentScriptWhen: 'start',
    contentScript: 'unsafeWindow.KBCeTokenFireFoxAddonVersion = 1;'
});

function startRenewal(worker) {
	var isValid = true;
/*	//debug code
	var zzz = new ctypes.unsigned_long(64);
	console.log('zzz: ' + zzz);
	console.log('zzz: ' + zzz.value.toSource());
	console.log('zzz: ' + zzz.value.toString());
	console.log('zzz: ' + ctypes.UInt64.lo(zzz.value));

	//debug code	
	var xxx = new ctypes.long(64);
	console.log('xxx: ' + xxx);
	console.log('xxx: ' + xxx.toSource());
	console.log('xxx: ' + xxx.toString());
*/	
	
	
/*	//debug code
	var aHexString = "61626a2061";
	console.log("aHexString: " + aHexString);
	console.log("byteArray: " + token.hexStringToByteArray(aHexString));
*/	
	try{
		token = tokenReq.Token();
	
	// close the token so we can re-init on page reentry
		try{
			token.close();
		} catch(err){
			isValid = false;
			errorStep(worker,"PREP","No driver/no provider "  + err.toString(),"E0002");
			//errorStep(worker,"PREP","No driver/no provider "  + err.toString(),"E0002");
		}
		
		try{
			var sessionHandle = token.init();
			console.log("init returned sessionHandle " + sessionHandle);

			var serial = token.getTokenSerial();
			console.log("token serial: " + serial);
			logStep(worker, "PREP", "token serial: " + serial);
			
			
			
			console.log("sending main.serial message ...");
			if(typeof serial == "string"){
				worker.port.emit("main.serial", serial);
				
			} else {
				isValid = false;
				throw "E0004";
			}
		} catch(err){
			isValid = false;
			var errorCode = "E0003";
			var errorText = "Nincs bedugva, nincs az egyesen ";
			if(typeof err == "string"){
				if(err.indexOf('E0004') >= 0){
					errorCode = "E0004";
					errorText = "Nem az eidhez tartozó token ";
				}
			}
				errorStep(worker,"PREP",errorText + err.toString(), errorCode);
			//errorStep(worker,"PREP","Nincs bedugva, nincs az egyesen " + err.toString(),"E0003");
		}
		
		worker.port.on("renewal.response", function (response) {
			console.log("response: " + response);
			if ( response == "inValid" ) {
					isValid = false;
			} else {
				try{
					if(isValid){
						token.login(sessionHandle, response);
					}
				} catch(err){
					isValid = false;
					var errorCode = "E0003";
					if(typeof err == "string"){
						if(err.indexOf('E0014') >= 0){
							errorCode = "E0014";
						}
						
						if(err.indexOf('E0001') >= 0){
							errorCode = "E0001";
						}
						
						if(err.indexOf('E0015') >= 0){
							errorCode = "E0015";
						}
					}
					errorStep(worker,"PREP", err.toString(),errorCode);
					//errorStep(worker,"PREP","Nincs bedugva, nincs az egyesen " + err.toString(),"E0001");
				}
				
				if(isValid){
	//				prompts.alert(null, "eToken", "about to generate login & signature key pairs");
					console.log("main.startReNew start");
					worker.port.emit("main.startReNew");
				}
			}
		});
		
		worker.port.on("renewal.generateKeyPairs", function (payload) {
			console.log("about to generate login & signature key pairs");
			
			const idString = generateKeyIdTimestamp();
			var loginId = idString + "_login";
			var signId = idString + "_sign";
			try{
				
				logStep(worker, "KEYGEN", "generating login key with id " + loginId);
				var loginKeyHandle = token.generateKeyPair(sessionHandle, 1024, loginId);
				
				logStep(worker, "KEYGEN", "generating signature key with id " + signId);

				var signKeyHandle = token.generateKeyPair(sessionHandle, 1024, signId);
			} catch(err){
				errorStep(worker,"KEYGEN","Keygen error "  + err.toString(),"E0006");
			}
			console.log("login key handle: pub " + loginKeyHandle.publicKey + ", priv " + loginKeyHandle.privateKey);
			console.log("signature key handle: pub " + signKeyHandle.publicKey + ", priv " + signKeyHandle.privateKey);
			try{
				var loginPubKeyObj = token.getPublicKeyInfo(sessionHandle, loginKeyHandle.publicKey)
				console.log("loginPubKeyObj n: " + loginPubKeyObj.n);
				console.log("loginPubKeyObj e: " + loginPubKeyObj.e);
				var signPubKeyObj = token.getPublicKeyInfo(sessionHandle, signKeyHandle.publicKey)
				console.log("signPubKeyObj n: " + signPubKeyObj.n);
				console.log("signPubKeyObj e: " + signPubKeyObj.e);
			} catch(err){
				errorStep(worker,"KEYGEN","Keygen error "  + err.toString(),"E0006");
			}
			console.log("sending main.pubKeyObj message ...");
			worker.port.emit("main.pubKeyObj", {"loginPubKeyObj": loginPubKeyObj, "signPubKeyObj": signPubKeyObj});
			
			worker.port.on("renewal.CRIs", function (CRIs) {
				console.log("renewal.CRIs message received.");
				console.log("loginCRI: " + CRIs.loginCRI);
				console.log("signCRI: " + CRIs.signCRI);
				
				try{
					logStep(worker, "KEYGEN", "generating digital signature for login & signature CSRs");

					var loginCRISignature = token.signCRI(sessionHandle, loginKeyHandle.publicKey, CRIs.loginCRI)
					var signCRISignature = token.signCRI(sessionHandle, signKeyHandle.publicKey, CRIs.signCRI)
					console.log("loginCRISignature: " + loginCRISignature);
					console.log("signCRISignature: " + signCRISignature);
				} catch(err){
					errorStep(worker,"STORE_RESP","Cert write error "  + err.toString(),"E0008");
				}
				worker.port.emit("main.CRISignatures", {"loginCRISignature": loginCRISignature, "signCRISignature": signCRISignature});
				
				worker.port.on("renewal.certificates", function (certificates) {
					console.log("renewal.certificates message received.");
					console.log("certificates.loginCert: " + certificates.loginCert);
					console.log("certificates.signCert: " + certificates.signCert);
					
					
					//token.findAll(sessionHandle);
					
				try{	
					logStep(worker, "STORE_RESP", "storing login certificate with subject: " + certificates.loginCert.subject);				
					var loginCertHandle = token.storeCertificate(sessionHandle, loginId, certificates.loginCert.certificate, certificates.loginCert.subject);
					logStep(worker, "STORE_RESP", "storing signature certificate with subject: " + certificates.signCert.subject);				

					var signCertHandle = token.storeCertificate(sessionHandle, signId, certificates.signCert.certificate, certificates.signCert.subject);
					console.log("loginCertHandle: " + loginCertHandle);
					console.log("signCertHandle: " + signCertHandle);
					worker.port.emit("main.callNextStep");
				} catch(err){
					errorStep(worker,"STORE_RESP","Token megtelt "  + err.toString(),"E0005");
				//errorStep(worker,"STORE_RESP","Token megtelt "  + err.toString(),"E0005");
				}
				
				try{
									/*********************************************************************/
					/*** DEV code: *******************************************************/
					/*** For testing only - delete certs & keys we just generated, *******/
					/*** keeps the token nice and clean, and reusable multiple times *****/
					/****************************e*****************************************/
	//				prompts.alert(null, "eToken", "deleting objects with id: " + loginId);
	//				token.deleteObjectById(sessionHandle, loginId);
	//	
	//				prompts.alert(null, "eToken", "deleting objects with id: " + signId);
	//				token.deleteObjectById(sessionHandle, signId);
					/*********************************************************************/
					
					/*********************************************************************/
					/*** PRODUCTION code: ************************************************/
					/*** Delete all token objects except those we generated **************/
					/*********************************************************************/
					
					logStep(worker, "DEL_OLD", "deleting obsolete objects from token");
//					prompts.alert(null, "eToken", "deleting old objects");
					var deletedObjects = token.deleteAllExcept(sessionHandle, [loginId, signId]);
					logStep(worker, "DEL_OLD", "IDs of objects deleted: " + deletedObjects.toString());
					worker.port.emit("main.callNextStep");
					/*********************************************************************/
					
					worker.port.emit("main.success");
				} catch(err){
					errorStep(worker,"DEL_OLD","Delete write error "  + err.toString(),"E0009");
				}
					
					

				})//end worker.port.on;		
			});//end worker.port.on
		});//end worker.port.on	
	} catch(err){
		errorStep(worker,"Unkown","Unkown error " + err.toString(),"E9999");
	}
	
	console.log("starRenewal function END!");
}//end startRenewal

function generateKeyIdTimestamp() {
	return "KBC_" + Date.now();
}

function logStep(worker, step, data) {
	try {
		console.log("logStep - step: " + step + ", data: " + data);
		worker.port.emit("main.log", {"step": step, "data": data});
	} catch (e) {
		console.log("Error sending main.log: " + e);
	}
}

function errorStep(worker, step, error, errorcode) {
	try {
		console.log("errorStep - step: " + step + ", error: " + error + ", errorcode: " + errorcode);
		worker.port.emit("main.error", {"step": step, "error": error, "errorcode": errorcode});
	} catch (e) {
		console.log("Error sending main.error: " + e);
	}
}


console.log("main.js end");


