﻿console.log("renewal.js start");

self.port.on("main.serial", function(addonPayload) {
	console.log("* main.serial message received.");
	document.getElementById("etoken-firefox-addon").innerHTML = "<br/>Token serial number: <b>" + addonPayload + "</b><br/>" + document.getElementById("etoken-firefox-addon").innerHTML;
	
	var subject;
	
	checkSerial ( addonPayload, function checkResponse ( response ) {
		console.log("response: " + response.result );		
		if ( response.result != "OK" ) {	
			self.port.emit("renewal.response", "inValid");
			errorStep( "PREP", "Nem az eidhez tartozó token", "KH0004" );
			
		} else {			
			console.log( "response.subject: " + response.subject.toString() );
			subject = response.subject.toString();
			self.port.emit( "renewal.response", response.subject.toString() );
		}
	}); 
	
	// Simple form for printing key and certificate information
/*	document.getElementById("etoken-firefox-addon").innerHTML =  document.getElementById("etoken-firefox-addon").innerHTML +
	'<p>login public key hexstring<textarea id="loginPubKeyObj" cols=65 rows=3></textarea></p>' + 
	'<p>login CSI hexstring<textarea id="loginCSIHex" cols=65 rows=3/></textarea></p>'; 

	document.getElementById("etoken-firefox-addon").innerHTML =  document.getElementById("etoken-firefox-addon").innerHTML +
	'<p>login CSR PEM<textarea id="loginCSRPEM" cols=65 rows=3/></textarea></p>' + 
	'<p>login Cert PEM<textarea id="loginCertPEM" cols=65 rows=3/></textarea></p>' +
	'<p>signature Cert PEM<textarea id="signCertPEM" cols=65 rows=3/></textarea></p>' +
	'<input id="CertSubmitButton" type="button" value="Store Cert (manual openssl)" />' +
	'<input id="ProcessCSR" type="button" value="Process CSR & Store (auto KHCA)" />';
*/
	document.getElementById("etoken-firefox-addon").innerHTML =  document.getElementById("etoken-firefox-addon").innerHTML +
	'<input id="GenerateKeyPairs" type="button" value="Begin Token Renewing" onclick="nextStep();nextStep();nextStep();"/>' +
//	'<input id="ProcessCSR" type="button" value="Process CSR & Store certificates" onclick="nextStep();nextStep();nextStep();"/>' + 
	'<input id="ProcessCSR" type="hidden" value="Process CSR & Store certificates" onclick="nextStep();nextStep();nextStep();"/>' + 
	'<input id="resetAddon" type="button" value="Reset" onclick="window.location.reload(false);"/>';
	
	$("#GenerateKeyPairs").prop("disabled",false);
	$("#ProcessCSR").prop("disabled",true);
	
	var loginCSR;
	var signCSR;
	var loginCRI;
	var signCRI;

	var loginSubject;
	var signSubject;
	var loginCert;
	var signCert;
	var x500Name;
	
	document.getElementById("GenerateKeyPairs").addEventListener("click", function(event) {
		console.log("* GenerateKeyPairs pressed");
		console.log("* sending renewal.generateKeyPairs message ...");
		$("#GenerateKeyPairs").prop("disabled", true);
		self.port.emit("renewal.generateKeyPairs");
		
		event.stopPropagation();
		event.preventDefault();
	}, false);

	document.getElementById("ProcessCSR").addEventListener("click", function(event) {
		console.log("* ProcessCSR pressed");
		
		if (loginCSR != null && signCSR != null) {
			sendCertRequest(loginCSR.getPEMString(), signCSR.getPEMString(), function(payload) {
				console.log("sendCertRequest entering callback");
				if (payload.result == "error") {
					throw "sendCertRequest returned with error";
				}
				console.log("payload.authSubject " + payload.authSubject);
				x500Name = new KJUR.asn1.pkcs10.X500Name({"str": payload.authSubject});
				loginSubject = x500Name.getEncodedHex();
				console.log("payload.signSubject " + payload.signSubject);
				x500Name = new KJUR.asn1.pkcs10.X500Name({"str": payload.signSubject});
				signSubject = x500Name.getEncodedHex();
				
				loginCert = {"certificate": KEYUTIL.getHexFromPEM(payload.auth), "subject": loginSubject};
				signCert = {"certificate": KEYUTIL.getHexFromPEM(payload.sign), "subject": signSubject};
				
				console.log("* sending renewal.certificates message ...");
				self.port.emit("renewal.certificates", {"loginCert": loginCert, "signCert": signCert});
			});

			$("#ProcessCSR").prop("disabled", true);

		} else {
			console.log("* Error - CSRs not initialized. Keys not generated?");
		}

		event.stopPropagation();
		event.preventDefault();
	}, false);

	self.port.on("main.pubKeyObj", function(addonPayload) {
		console.log("* main.pubKeyObj message received.");
		$("#GenerateKeyPairs").prop("disabled",true);
		$("#ProcessCSR").prop("disabled",false);
		
		console.log("* loginPubKeyObj.n: " + addonPayload.loginPubKeyObj.n);
		console.log("* loginPubKeyObj.e: " + addonPayload.loginPubKeyObj.e);
		console.log("* signPubKeyObj.n: " + addonPayload.signPubKeyObj.n);
		console.log("* signPubKeyObj.e: " + addonPayload.signPubKeyObj.e);

		loginCRI = new KJUR.asn1.pkcs10.CertificationRequestInfo();
		signCRI = new KJUR.asn1.pkcs10.CertificationRequestInfo();
		console.log("subject: " + subject);
		loginCRI.setSubjectByParam({'str': subject});
		loginCRI.setSubjectPublicKeyByGetKey(addonPayload.loginPubKeyObj);
		signCRI.setSubjectByParam({'str': subject});
		signCRI.setSubjectPublicKeyByGetKey(addonPayload.signPubKeyObj);
		console.log("* loginCRI hex: " + loginCRI.getEncodedHex());
		console.log("* signCRI hex: " + signCRI.getEncodedHex());
	
		console.log("* sending renewal.CRIs message ...");
		self.port.emit("renewal.CRIs", {"loginCRI": loginCRI.getEncodedHex(),"signCRI": signCRI.getEncodedHex()});
		
		self.port.on("main.CRISignatures", function(addonPayload) {
			console.log("* main.CRISignatures message received.");
			console.log("* loginCRISignature: " + addonPayload.loginCRISignature);
			console.log("* signCRISignature: " + addonPayload.signCRISignature);
			
			loginCSR = new KJUR.asn1.pkcs10.CertificationRequest({'tbscertobj': loginCRI});
			signCSR = new KJUR.asn1.pkcs10.CertificationRequest({'tbscertobj': signCRI});
			loginCSR.setSignatureHex(addonPayload.loginCRISignature);
			signCSR.setSignatureHex(addonPayload.signCRISignature);
			
//			console.log("* loginCSR hex: " + loginCSR.getEncodedHex());
			console.log("* loginCSR pem: " + loginCSR.getPEMString());
			console.log("* signCSR pem: " + signCSR.getPEMString());	
			document.getElementById('ProcessCSR').click();
		});

		

	});
	
	self.port.on("main.success", function () {
		sendClientSuccess(function(payload) {		
			if (payload.result == "ok"){
				content.wrappedJSObject.location = "./../../success";
			} else {
				errorStep("FINISH", "Server error: " + payload.result, "KH0100");			
			}
		
		});
	});
});


self.port.on("main.error", function(addonPayload) {
	console.log("* main.error message received.");
	errorStep(addonPayload.step, addonPayload.error, addonPayload.errorcode);
});

self.port.on("main.log", function(addonPayload) {
	console.log("* main.log message received.");
	logStep(addonPayload.step, addonPayload.data);
});


function errorStep(step, error, errorcode) {
	console.log("Error in step '" + step + "': " + error);
	logStep(step, error);
	if (errorcode) {
		console.log("redirecting to error page ...");
		content.wrappedJSObject.location = "./../../error?code=" + errorcode;
	}
}

function logStep(step, data) {
	$.ajax({
		type: "POST",
		url: "certreq?mode=log",
		data: { data: data, step: step },
		dataType: 'json', 
		error: ajaxError
	});
}

function checkSerial(serial, callBack) {
	console.log("checkSerial start");
		$.ajax({
			type: "POST",
			url: "certreq?mode=checkSerial",
			data: {
				"type": "checkSerial",
				"serial": serial
			},
			dataType: 'json',
			timeout: 60000,		
			error: ajaxError,
			success: callBack,
		});
	console.log("checkSerial end");
}

function ajaxError(jqXHR, textStatus, errorThrown) {
	console.log("Ajax error: " + textStatus + ", " + errorThrown);
//	alert("Ajax error: " + textStatus + ", " + errorThrown);
} 

function sendCertRequest(loginCSR, signCSR, callBack) {
	console.log("sendCertRequest start");
	$.ajax({
		type: "POST",
		url: "certreq?mode=request",
		data: {
			"type": "request",
			"auth": loginCSR,
			"sign": signCSR,			
			"certContainer": "PEM"
		},
		dataType: "json",
		timeout: 60000,
		error: ajaxError,
		success: callBack,
	});
	console.log("sendCertRequest end");
}

function sendClientSuccess( callBack ){
	console.log("sendCertRequest start");
	$.ajax({
		type: "POST",
		url: "certreq?mode=clientSuccess",
		data: {},
		dataType: 'json',
		timeout: 60000,
		error: function(jqXHR, textStatus, errorThrown){
			errorStep("KEYGEN", "Ajax error: " + textStatus + ", " + errorThrown, "KH9999");
		},
		success: function(ret){
			if (ret.result == "ok"){
				window.location = "./../../success";
			} else {
			//	errorStep("FINISH", "Server error", "KH0100");
				errorStep("FINISH", "Server error", "");
				window.location = "./../../success";
			}
		}
	});
}

console.log("renewal.js end");
